/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.test;

import com.ibm.icu.text.BreakIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.Node;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.GLWrapper;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.shader.ShaderProgram;
import icyllis.modernui.graphics.shader.program.ArcProgram;
import icyllis.modernui.graphics.shader.program.CircleProgram;
import icyllis.modernui.graphics.shader.program.RectProgram;
import icyllis.modernui.graphics.shader.program.RoundRectProgram;
import icyllis.modernui.math.Matrix4;
import icyllis.modernui.math.Quaternion;
import icyllis.modernui.math.Vector3;
import icyllis.modernui.platform.Bitmap;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.platform.Window;
import icyllis.modernui.text.GraphemeBreak;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.Callback;

public class TestMain {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Test");
    private static final List<Font> ALL_FONTS;
    private static final BufferedImage IMAGE;
    private static final Graphics2D GRAPHICS;
    public static final boolean CREATE_WINDOW = true;
    private static double nextTime;
    private static boolean needRedraw;
    private static Window sWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        float[] av = new float[]{1.0f, 3.0f, 2.0f, 4.1f, 6.0f, 0.0f, 6.0f, 0.5f, 5.0f, 7.0f, 11.3f, 9.0f, 9.1f, 15.0f, 8.0f, 10.0f};
        float[] bv = new float[]{9.1f, 2.0f, 7.0f, 5.0f, 3.3f, 6.1f, 5.5f, 4.0f, 0.0f, 8.0f, 3.0f, 1.0f, 2.7f, 3.0f, 9.0f, 2.0f};
        Vector3 vec1 = new Vector3(5.0f, 2.0f, 2.0f);
        Vector3 vec2 = vec1.copy();
        Vector3 vec3 = vec2.copy();
        Quaternion q = Quaternion.makeAxisAngle(1.0f, 0.0f, 0.0f, 0.7853982f);
        vec1.transform(q.toMatrix4());
        vec2.transform(q);
        Matrix4 mat = Matrix4.identity();
        mat.rotateX(0.7853982f);
        vec3.transform(mat);
        ModernUI.LOGGER.info("\n{}\n{}\n{}\nEq: {}, {}", (Object)vec1, (Object)vec2, (Object)vec3, (Object)vec1.equivalent(vec2), (Object)vec2.equivalent(vec3));
        try {
            Thread.currentThread().setName("Main-Thread");
            RenderCore.initBackend();
            sWindow = new Window("Modern UI Layout Editor", Window.State.WINDOWED, 1280, 720);
            Thread t = new Thread(() -> {
                Window window = sWindow;
                window.makeCurrent();
                RenderCore.initialize();
                RenderSystem.initRenderThread();
                ArcProgram.createPrograms();
                CircleProgram.createPrograms();
                RectProgram.createPrograms();
                RoundRectProgram.createPrograms();
                ShaderProgram.linkAll(null);
                float[] projection = new float[16];
                Matrix4.makePerspective(1.5707964f, window.getAspectRatio(), 0.001f, 1000.0f).put(projection);
                while (window.exists()) {
                    if (window.needsRefresh()) {
                        GLWrapper.reset(window);
                        GLWrapper.enableCull();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.disableDepthTest();
                        GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        GlStateManager.func_227667_a_((boolean)false);
                        GL11.glMatrixMode((int)5889);
                        GL43.glPushMatrix();
                        GL11.glLoadIdentity();
                        GL11.glMultMatrixf((float[])projection);
                        GL11.glMatrixMode((int)5888);
                        GL43.glPushMatrix();
                        GL11.glLoadIdentity();
                        Paint paint = Paint.take();
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)(-1.58f * window.getAspectRatio()), (float)-1.0f, (float)-3.8f);
                        GL11.glScalef((float)0.011111111f, (float)-0.011111111f, (float)0.011111111f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        paint.reset();
                        paint.setFeatherRadius(6.0f);
                        paint.setStyle(Paint.Style.STROKE);
                        paint.setStrokeWidth(16.0f);
                        Canvas.getInstance().drawRoundRect(0.0f, 20.0f, 100.0f, 70.0f, 14.0f, paint);
                        paint.setColor(-5579536);
                        Canvas.getInstance().drawRoundRect(0.0f, -110.0f, 100.0f, -60.0f, 14.0f, paint);
                        GL11.glPopMatrix();
                        GL11.glTranslatef((float)(1.58f * window.getAspectRatio()), (float)1.0f, (float)-4.8f);
                        GL11.glScalef((float)0.011111111f, (float)-0.011111111f, (float)0.011111111f);
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        Canvas.getInstance().drawRoundRect(0.0f, 20.0f, 100.0f, 70.0f, 14.0f, paint);
                        Canvas.getInstance().drawRoundRect(-20.0f, 190.0f, 80.0f, 240.0f, 14.0f, paint);
                        Canvas.getInstance().setLineAntiAliasing(true);
                        Canvas.getInstance().drawRect(-20.0f, 0.0f, 120.0f, 90.0f, paint);
                        GL11.glPopMatrix();
                        GL11.glMatrixMode((int)5889);
                        GL11.glPopMatrix();
                        GL11.glMatrixMode((int)5888);
                        window.swapBuffers();
                    }
                    try {
                        Thread.currentThread().join(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }, "Render-Thread");
            t.start();
            new Thread(() -> {
                try (Bitmap b = Bitmap.openDialog(Bitmap.Format.RGBA);){
                    if (b != null) {
                        b.saveDialog(Bitmap.SaveFormat.PNG, 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "Open-File").start();
            while (sWindow == null || sWindow.exists()) {
                GLFW.glfwWaitEventsTimeout((double)0.016666666666666666);
            }
            t.interrupt();
            if (sWindow != null) {
                sWindow.destroy();
            }
        }
        catch (Throwable throwable) {
            if (sWindow != null) {
                sWindow.destroy();
            }
            Stream.of(GLFW.glfwSetMonitorCallback(null), GLFW.glfwSetErrorCallback(null)).filter(x$0 -> Objects.nonNull(x$0)).forEach(rec$ -> ((Callback)rec$).free());
            GLFW.glfwTerminate();
            ModernUI.LOGGER.info(MARKER, "Stopped");
            throw throwable;
        }
        Stream.of(GLFW.glfwSetMonitorCallback(null), GLFW.glfwSetErrorCallback(null)).filter(x$0 -> Objects.nonNull(x$0)).forEach(rec$ -> ((Callback)rec$).free());
        GLFW.glfwTerminate();
        ModernUI.LOGGER.info(MARKER, "Stopped");
    }

    public static float calcMachineEpsilon() {
        float machEps = 1.0f;
        while (1.0f + (machEps /= 2.0f) / 2.0f != 1.0f) {
        }
        return machEps;
    }

    public static void breakGraphemes(String s2) {
        GraphemeBreak.sUseICU = true;
        int offset = 0;
        int prevOffset = 0;
        Font font = ALL_FONTS.stream().filter(f -> f.canDisplayUpTo("\u0641\u0647\u0648") == -1).findFirst().get();
        while ((offset = GraphemeBreak.getTextRunCursor(s2, Locale.getDefault(), 0, s2.length(), offset, 0)) != prevOffset) {
            TestMain.toEscapeChars(s2.substring(prevOffset, offset));
            GlyphVector vector = font.layoutGlyphVector(GRAPHICS.getFontRenderContext(), s2.toCharArray(), prevOffset, offset, 1);
            for (int i = 0; i < vector.getNumGlyphs(); ++i) {
                ModernUI.LOGGER.info(MARKER, "GlyphCode: {}", (Object)vector.getGlyphCode(i));
            }
            prevOffset = offset;
        }
    }

    public static void breakWords(String s2) {
        int count = 0;
        BreakIterator iterator = BreakIterator.getWordInstance((Locale)Locale.ROOT);
        iterator.setText(s2);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            TestMain.toEscapeChars(s2.substring(start, end));
            ++count;
            start = end;
            end = iterator.next();
        }
        ModernUI.LOGGER.info(MARKER, "Word break count: {}", (Object)count);
    }

    public static void toEscapeChars(String t) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < t.length(); ++i) {
            builder.append("\\u");
            builder.append(Integer.toString(t.charAt(i) | 0x10000, 16).substring(1));
        }
        ModernUI.LOGGER.info(MARKER, builder.toString());
    }

    public static void testGraphemeBreak() {
        GraphemeBreak.sUseICU = true;
        String bengaliHello = "\u09b9\u09cd\u09af\u09be\u09b2\u09cb";
        ModernUI.LOGGER.info(MARKER, (Object)GraphemeBreak.getTextRunCursor(bengaliHello, Locale.getDefault(), 3, bengaliHello.length(), bengaliHello.length(), 2));
    }

    public static void testMarkdownParsing() {
        Parser parser = Parser.builder().build();
        Document document = parser.parse("Advanced Page\r\n---\r\nMy **One** Line\r\n> My Two");
        TestMain.iterateNode(document, 0);
    }

    private static void iterateNode(@Nonnull Node node, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        ++depth;
        ModernUI.LOGGER.info(MARKER, "{}{}", (Object)sb, (Object)node);
        Node child = Node.AST_ADAPTER.getFirstChild(node);
        while (child != null) {
            TestMain.iterateNode(child, depth);
            child = Node.AST_ADAPTER.getNext(child);
        }
    }

    private static void drawText() {
    }

    static {
        IMAGE = new BufferedImage(1024, 1024, 2);
        GRAPHICS = IMAGE.createGraphics();
        nextTime = 0.0;
        needRedraw = true;
        GraphicsEnvironment.getLocalGraphicsEnvironment().preferLocaleFonts();
        ALL_FONTS = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts());
        GRAPHICS.setColor(Color.BLACK);
        GRAPHICS.fillRect(0, 0, 1024, 1024);
        GRAPHICS.setColor(Color.WHITE);
        GRAPHICS.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        GRAPHICS.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        GRAPHICS.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

